/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.computer;

import com.google.common.collect.Sets;
import cz.insophy.inplan.report.CapacityUsageDateMode;
import cz.insophy.inplan.report.CapacityUsageRebuildMode;
import cz.insophy.inplan.report.CapacityUsageWrapper;
import cz.insophy.inplan.report.ReportUtilities;
import cz.insophy.inplan.report.computer.AbstractReportComputer;
import cz.insophy.inplan.report.result.CapacityUsageCapabilityTableRow;
import cz.insophy.inplan.report.result.CapacityUsageGorTableRow;
import cz.insophy.inplan.report.result.CapacityUsageResult;
import cz.insophy.inplan.report.result.CapacityUsageResultRows;
import cz.insophy.inplan.report.result.CapacityUsageTableRow;
import cz.insophy.inplan.report.result.CapacityUsageWorkplaceTableRow;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.CalendarHelper;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.TimeSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapacityUsageComputer
extends AbstractReportComputer<CapacityUsageResult> {
    private static final Logger LOG = LoggerFactory.getLogger(CapacityUsageComputer.class);
    private long startDate = 0L;
    private long endDate = 0L;
    private CapacityUsageRebuildMode rebuildMode = CapacityUsageRebuildMode.NO_REBUILD;
    private CapacityUsageDateMode dateMode = CapacityUsageDateMode.DUE_DATE;
    private boolean negativeOnly = false;
    private boolean selectedOnly = false;
    private boolean includeEarlyGors = false;

    public void setDates(long startDate, long endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        LOG.debug("Start date: " + Formatter.formatLongDateTime(startDate));
        LOG.debug("End date: " + Formatter.formatLongDateTime(endDate));
        if (!GeneralizedRequest.isDateValid(this.startDate) || !GeneralizedRequest.isDateValid(this.endDate)) {
            LOG.warn("Invalid dates.");
            throw new IllegalArgumentException();
        }
        if (this.startDate >= this.endDate) {
            LOG.warn("End date must be higher than the start date.");
            throw new IllegalArgumentException();
        }
    }

    public void setRebuildMode(CapacityUsageRebuildMode mode) {
        this.rebuildMode = mode;
    }

    public void setDateMode(CapacityUsageDateMode mode) {
        this.dateMode = mode;
    }

    public void setFlags(boolean showNegativeOnly, boolean showSelectedOnly, boolean includeEarlyGors) {
        this.negativeOnly = showNegativeOnly;
        this.selectedOnly = showSelectedOnly;
        this.includeEarlyGors = includeEarlyGors;
    }

    @Override
    public CapacityUsageResult compute(Superplan superplan) {
        if (this.startDate == 0L || this.endDate == 0L) {
            LOG.warn("Unset start date or end date.");
            return null;
        }
        if (!GeneralizedRequest.isDateValid(this.startDate) || !GeneralizedRequest.isDateValid(this.endDate)) {
            LOG.warn("Invalid start date or end date.");
            return null;
        }
        if (this.startDate >= this.endDate) {
            LOG.warn("Start date must not be later than end date.");
            return null;
        }
        if (this.rebuildMode == null) {
            LOG.warn("No rebuild mode chosen.");
            return null;
        }
        ShopConfiguration config = superplan.getShopConf();
        LOG.debug("Creating the main wrapper object...");
        CapacityUsageWrapper wrapper = new CapacityUsageWrapper(config);
        LOG.debug("Giving capacity...");
        CapacityUsageComputer.giveCapacity(superplan, wrapper, this.startDate, this.endDate);
        ArrayList<GeneralizedOrderRequest> gors = new ArrayList<GeneralizedOrderRequest>();
        if (this.selectedOnly) {
            for (GeneralizedOrderRequest gor : superplan.getGors()) {
                if (!gor.isUserSelected()) continue;
                gors.add(gor);
            }
        } else {
            gors.addAll(superplan.getGors());
        }
        LOG.debug("Taking capacity...");
        CapacityUsageComputer.takeCapacity(superplan.getSDGraph(), gors, wrapper, this.includeEarlyGors, this.startDate, this.endDate, this.rebuildMode, this.dateMode);
        LOG.debug("Converting to rows...");
        ArrayList<CapacityUsageTableRow> rows = new ArrayList<CapacityUsageTableRow>(100);
        CapacityUsageResultRows dependentData = new CapacityUsageResultRows();
        for (CapabilityIsland island : wrapper.getIslands()) {
            if (this.negativeOnly && !wrapper.getIslandEvents(island).isNegative(this.startDate, this.endDate)) continue;
            CapacityUsageTableRow row = new CapacityUsageTableRow(island, wrapper.getIslandEvents(island));
            rows.add(row);
            dependentData.putCapabilityRows(row, CapacityUsageComputer.createCapabilityRows(row, wrapper));
            dependentData.putWorkplaceRows(row, CapacityUsageComputer.createWorkplaceRows(row));
            dependentData.putGorRows(row, CapacityUsageComputer.createGorRows(row, wrapper));
        }
        Collections.sort(rows);
        dependentData.sort();
        return new CapacityUsageResult(rows, dependentData);
    }

    private static void giveCapacity(Superplan superplan, CapacityUsageWrapper wrapper, long startDate, long endDate) {
        long onlineTime;
        LOG.debug("Giving capacity to workplaces...");
        for (String capability : wrapper.getAllCapabilities()) {
            for (Workplace workplace : superplan.getShopConf().getWorkplaces(capability)) {
                for (TimeSpan s2 : CalendarHelper.splitAtMidnight(startDate, endDate)) {
                    onlineTime = ReportUtilities.getWorkplaceOnlineTime(superplan.getPlan(), workplace, s2.getStart(), s2.getEnd());
                    wrapper.addCapacity(workplace, capability, s2.getStart(), (double)onlineTime);
                }
            }
        }
        LOG.debug("Giving capacity to capability islands...");
        for (CapabilityIsland island : wrapper.getIslands()) {
            for (Workplace workplace : island.getWorkplaces()) {
                for (TimeSpan s2 : CalendarHelper.splitAtMidnight(startDate, endDate)) {
                    onlineTime = ReportUtilities.getWorkplaceOnlineTime(superplan.getPlan(), workplace, s2.getStart(), s2.getEnd());
                    wrapper.addCapacity(workplace, island, s2.getStart(), (double)onlineTime);
                }
            }
        }
    }

    private static void takeCapacity(StoreDependencyGraph sdg, List<GeneralizedOrderRequest> gors, CapacityUsageWrapper wrapper, boolean includeEarlyGors, long startDate, long endDate, CapacityUsageRebuildMode rebuildMode, CapacityUsageDateMode dateMode) {
        HashSet<String> doneRebuildTypes = Sets.newHashSet();
        gors.sort(Comparator.comparingLong(GeneralizedRequest::getDueDate));
        for (GeneralizedOrderRequest gor : gors) {
            long gorDate = switch (dateMode) {
                case CapacityUsageDateMode.DUE_DATE -> gor.getDueDate();
                case CapacityUsageDateMode.MATERIAL_DATE -> {
                    long materialDate = sdg.getNode(gor).getMatprodPreparedTime();
                    if (materialDate == -1L) {
                        yield gor.getReleaseDate();
                    }
                    yield materialDate;
                }
                default -> throw new IndexOutOfBoundsException();
            };
            if (gorDate > endDate || !includeEarlyGors && gorDate < startDate) continue;
            LOG.debug("Taking capacity and processing GOR: " + gor.getId());
            Actiongram alternative = ReportUtilities.getBestActiongram(gor);
            for (Action action : alternative.getActions()) {
                double qty;
                double qtyCompleted;
                GeneralizedActionRequest gar = gor.getGar(action.getName());
                if (gar == null) {
                    qtyCompleted = 0.0;
                    qty = gor.getRequestedQty();
                } else {
                    qtyCompleted = gar.getCompletedQty();
                    qty = gar.getRequestedQty();
                }
                double qtyRemaining = Math.max(0.0, qty - qtyCompleted);
                double capacityTaken = action.normtime(qtyRemaining);
                if (capacityTaken > 1.0E-7) {
                    switch (rebuildMode) {
                        case FULL_REBUILD: {
                            capacityTaken += (double)gor.getSuperplan().getShopConf().getMaxRebuildTime(action);
                            break;
                        }
                        case MINIMAL_REBUILD: {
                            if (doneRebuildTypes.contains(action.getRebuildType())) break;
                            capacityTaken += (double)gor.getSuperplan().getShopConf().getMaxRebuildTime(action);
                            doneRebuildTypes.add(action.getRebuildType());
                            break;
                        }
                    }
                }
                wrapper.takeCapacity(action.getCapabilityReq(), gorDate, capacityTaken, gor);
            }
        }
    }

    private static List<CapacityUsageCapabilityTableRow> createCapabilityRows(CapacityUsageTableRow row, CapacityUsageWrapper wrapper) {
        ArrayList<CapacityUsageCapabilityTableRow> rows = new ArrayList<CapacityUsageCapabilityTableRow>();
        for (String capability : row.getIsland().getCapabilities()) {
            rows.add(new CapacityUsageCapabilityTableRow(capability, wrapper.getCapabilityEvents(capability)));
        }
        return rows;
    }

    private static List<CapacityUsageWorkplaceTableRow> createWorkplaceRows(CapacityUsageTableRow row) {
        ArrayList<CapacityUsageWorkplaceTableRow> rows = new ArrayList<CapacityUsageWorkplaceTableRow>();
        for (Workplace workplace : row.getIsland().getWorkplaces()) {
            rows.add(new CapacityUsageWorkplaceTableRow(workplace.getName(), workplace.getDescription()));
        }
        return rows;
    }

    private static List<CapacityUsageGorTableRow> createGorRows(CapacityUsageTableRow row, CapacityUsageWrapper wrapper) {
        ArrayList<CapacityUsageGorTableRow> rows = new ArrayList<CapacityUsageGorTableRow>();
        for (GeneralizedOrderRequest gor : wrapper.getIslandGors(row.getIsland())) {
            long gorCapacityUsed = wrapper.getGorCapacityUsed(row.getIsland(), gor);
            long availableCapacity = row.getCapacityFree();
            rows.add(new CapacityUsageGorTableRow(gor, CapacityUsageComputer.asString(wrapper.getGorCapabilities(row.getIsland(), gor)), gorCapacityUsed, (double)gorCapacityUsed / (double)availableCapacity));
        }
        return rows;
    }

    private static String asString(Collection<String> capabilities) {
        if (capabilities.isEmpty()) {
            return "~";
        }
        ArrayList<String> result = new ArrayList<String>(capabilities);
        Collections.sort(result);
        return ((Object)result).toString();
    }
}

